/*
Requests can be batched together into one network call. This
makes for efficient network programming...
*/

var value = 100.21, // Try changing this value to a different number!
    sub = new baja.Subscriber(); // Listen for when any of the points change...
sub.attach("changed", function() { 
  baja.outln(this.toPathString() + " -> " + this.getOutDisplay()); 
});

baja.Ord.make("station:|slot:/BajaScriptTutorials/Batch").get({
  ok: function(folder) { 
 
    // All network calls are batched into the batch...
    var batch = new baja.comm.Batch(),
        points = folder.getSlots().is("control:NumericWritable").toValueArray();      

    // Iterate through the points array and invoke the 'set' Action
    baja.iterate(points, function(pnt) {
      // Note how the Action invocation method is called 'set1' since there is already a
      // method called 'set' on baja.Component (of course, the Property is still called 'set')
      pnt.set1({
        value: value, 
        batch: batch
      });
    });    
        
    // Subscribe to all of these points...
    sub.subscribe({
      comps: points,
      batch: batch
    });

    // Add a callback that will be made once all of the previous network requests have happened
    batch.addCallback(function () {
      baja.outln("Finished calling set on all of the points!!!");
    });

    // Commit the batch asynchronously
    batch.commit();
  },
  lease: true
});

// Note that if other students are also going through this tutorial on this Station right now, then you may see some unexpected results!
